<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Route extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "route";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Route_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		$this->load->model('Sequerty_Model');
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('route',$data);
	}
	
	
	public function get_all_route_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$route = $this->Route_Model->get_all_route_by_warehouse_id($warehouse_id);
		echo json_encode($route);
		
		
	
		
	}
	
	
	public function get_all_sales_rep_issue_by_route_id()
	{
	
		$route=$this->input->get('RI');
		$Sales_rep_issue = $this->Route_Model->get_all_sale_rep_issue_by_route_id($route);
		echo json_encode($Sales_rep_issue);
		
		
	
		
	}
	
	
	public function save_route()
	{
		$route_id=$this->input->post('route_id');
		$type=$this->input->post('type');
		$route_name=$this->input->post('route_name');
		$route_code=$this->input->post('route_code');
		$warehouse_id=$this->input->post('warehouse_id');
		$data=array(
			'route_name'=>$route_name,
			'route_code'=>$route_code,
			'warehouse_id'=>$warehouse_id
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required|is_unique[routes.route_code]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('route_code', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Route_Model->save_route($data,$route_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	public function add_route()
	{
        if (isset($_GET['route_id'])) {
			$route_id=$_GET['route_id'];
		}
		else {
			$route_id='';
		}
		if($route_id){
			$data['route_id']=$route_id;
			$data['type']='E';
			$data['pageName']='UPDATE  ROUTE';
			$data['btnText']='Update Route';
			$data['suppliyer']= $this->Route_Model->get_route_info($route_id);	
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
		else {
			$data['route_id']='';
			$data['type']='A';
			$data['pageName']='ADD ROUTE';
			$data['btnText']='Add Route';
			$data['routes_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
        $this->load->view('models/create_route',$data);
	}

	public function list_route()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'route_code', 
		1 => 'route_name'
	);
	
	$data = array();
	$route = $this->Route_Model->get_all_route();
	$totalData = count($route);
	$totalFiltered = $totalData;  
	
	foreach ($route as $row){
		$nestedData=array(); 
		$nestedData[] =$row['route_code'];
		$nestedData[] = $row['route_name'];
		$nestedData[] = $row['name'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='<a onClick="click_route_update_btn('.$row['route_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['route_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['route_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['route_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['route_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['route_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_route() {
		$route_id	= $this->input->post('route_id');
		$this->Route_Model->delete_route($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_route() {
		$route_id	= $this->input->post('route_id');
		$this->Route_Model->disable_route($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_route() {
		$route_id	= $this->input->post('route_id');
		$this->Route_Model->enable_route($route_id);
        if ($route_id) {
        	echo json_encode(array('id'=>$route_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}