<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Drivers extends CI_Controller {

    var $main_menu_name = "people";
	var $sub_menu_name = "drivers";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Drivers_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Common_Model');
		
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('drivers/list_drivers',$data);
	}
	
	
	public function get_all_drivers_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$driver = $this->Drivers_Model->get_all_driver_by_warehouse_id($warehouse_id);
		echo json_encode($driver);
		
		
	
		
	}
	
	
	public function save_driver()
	{
		$driver_id=$this->input->post('driver_id');
		$driver_name=$this->input->post('driver_name');
		$driver_code=$this->input->post('driver_code');
		$driver_description=$this->input->post('driver_details');
		$driver_phone=$this->input->post('driver_phone');
		$warehouse_id=$this->input->post('warehouse_id');
		$type=$this->input->post('type');
		$data=array(
			'driver_name'=>$driver_name,
			'driver_phone'=>$driver_phone,
			'driver_description'=>$driver_description,
			'driver_code'=>$driver_code,
			'driver_wh_id'=>$warehouse_id
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{
			$this->form_validation->set_rules('driver_code', 'Code', 'required|is_unique[drivers.driver_code]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('driver_id', 'ID', 'required');
			$this->form_validation->set_rules('driver_code', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Drivers_Model->save_driver($data,$driver_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	public function add_driver()
	{
        if (isset($_GET['driver_id'])) {
			$driver_id=$_GET['driver_id'];
		}
		else {
			$driver_id='';
		}
		if($driver_id){
			$data['driver_id']=$driver_id;
			$data['type']='E';
			$data['pageName']='UPDATE  driver';
			$data['btnText']='Update driver';
			$data['drivers_details']= $this->Drivers_Model->get_driver_info($driver_id);	
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
		else {
			$data['driver_id']='';
			$data['type']='A';
			$data['pageName']='ADD driver';
			$data['btnText']='Add driver';
			$data['drivers_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
        $this->load->view('models/create_driver',$data);
	}

	public function list_driver()
	{
	$requestData= $_REQUEST;
	
	$columns = array( 
		0 =>'driver_code', 
		1 => 'driver_name'
	);
	
	$data = array();
	$driver = $this->Drivers_Model->get_all_driver();
	$totalData = count($driver);
	$totalFiltered = $totalData;  
	
	foreach ($driver as $row){
		$nestedData=array(); 
		$nestedData[] =$row['driver_code'];
		$nestedData[] = $row['driver_name'];
		$nestedData[] = $row['name'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='<a onClick="click_driver_update_btn('.$row['driver_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['driver_status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['driver_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['driver_status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['driver_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['driver_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_driver() {
		$driver_id	= $this->input->post('driver_id');
		$this->Drivers_Model->delete_driver($driver_id);
        if ($driver_id) {
        	echo json_encode(array('id'=>$driver_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_driver() {
		$driver_id	= $this->input->post('driver_id');
		$this->Drivers_Model->disable_driver($driver_id);
        if ($driver_id) {
        	echo json_encode(array('id'=>$driver_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_driver() {
		$driver_id	= $this->input->post('driver_id');
		$this->Drivers_Model->enable_driver($driver_id);
        if ($driver_id) {
        	echo json_encode(array('id'=>$driver_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
}