<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');
   
class Core_Stock_In_Out extends CI_Controller
{
    var $main_menu_name = "store";
    var $sub_menu_name = "";
    private $main_model;
   
    public function __construct()
    {
        parent::__construct();
        date_default_timezone_set("Asia/Colombo");
        $this->load->model('Common_Model');
        $this->load->model('Stock_In_Out_Model');
        $this->main_model=new Stock_In_Out_Model();
        $this->load->model('Stock_Counter_Model');
        
        
    }
    public function index()
    {
       show_404();
    }
    //standard function
     protected function cleanAndValidateNumber($id){
        $this->load->helper("security");
        $recode_id = $this->security->xss_clean($id); 
       
        if($recode_id>=0&&$recode_id<999999){
            return $recode_id;
        }else{
            echo "invalid Number ";
            exit();
            return false;
        }
    }
    protected function cleanAndValidateText($text){
        $this->load->helper("security");
        $text = $this->security->xss_clean($text); 
        $text= preg_replace('/[^A-Za-z0-9\-]/', '', $text);
        return substr($text, 0, 255);
    }
    protected function cleanAndValidateArray($data){
        //$this->load->helper("security");
        //$data = $this->security->xss_clean($data); 
        return $data;
    }
     protected function getClientSideDataTableParameters(){
        $start          = $this->input->get('start');
        $length         = $this->input->get('length');
        $search_key     = $this->input->get('search');
        $id             = $this->input->get('id');
        $search_key_val = $search_key['value'];
        $data=array();
        $data['start']=$this->cleanAndValidateNumber($start);
        $data['length']=$this->cleanAndValidateNumber($length);
        $data['search_key_val']=$this->cleanAndValidateText($search_key['value']);
        $data['custom_condition']=array('id'=>$id);
        return $data;
    }
     protected function getClientSideBasicDataTableParameters(){
        $id = $this->input->get('id');
        $data=array();
        $data['id']=$this->cleanAndValidateNumber($id);
        $data['custom_condition']=array();
        return $data;
    }
     protected function getId(){
         $id = $this->input->post('id');
        if($id){
            return $this->cleanAndValidateNumber($id);
        }else{
            $id = $this->input->get('id');
            return $this->cleanAndValidateNumber($id);
        }
    }
    protected function executeSaveMasterTable($data){
        return $this->main_model->runSaveMaster($data);
    }
    protected function executeSaveItemTable($data){
        return $this->main_model->runSaveItems($data);
    }
    protected function executeSaveSubItemTable($data){
        return $this->main_model->runSaveSubItems($data);
    }
    protected function executeUpdateMasterTable($id,$data){
        return $this->main_model->runUpdateMasterUsingPrimaryId($id,$data);
    }
    protected function executeUpdateItemTable($id,$data){
        return $this->main_model->runUpdateItemsUsingPrimaryId($id,$data);
    }
    protected function executeUpdateSubItemTable($id,$data){
        return $this->main_model->runUpdateSubItemsUsingPrimaryId($id,$data);
    }
    protected function executeDeleteMasterTable($id){
        return $this->main_model->runDeleteMasterUsingPrimaryId($id);
    }
    protected function executeDeleteItemTable($id){
        return $this->main_model->runDeleteItemsUsingPrimaryId($id);
    }
    protected function executeDeleteSubIteTable($id){
        return $this->main_model->runDeleteSubItemsUsingPrimaryId($id);
    }
    protected function executeSelectMasterTable($id){
        return $this->main_model->runSelectMasterUsingPrimaryId($id);
    }
    protected function executeSelectItemTable($id){
        return $this->main_model->runSelectItemsUsingPrimaryId($id);
    }
    protected function executeSelectSubItemsTable($id){
        return $this->main_model->runSelectSubItemsUsingPrimaryId($id);
    }
    protected function executeUpdateMasterTableUsingSecondaryId($id,$data){
        return $this->main_model->runUpdateMasterUsingSecondaryId($id,$data);
    }
    protected function executeUpdateItemTableUsingSecondaryId($id,$data){
        return $this->main_model->runUpdateItemsUsingSecondaryId($id,$data);
    }
    protected function executeUpdateSubItemTableUsingSecondaryId($id,$data){
        return $this->main_model->runUpdateSubItemsUsingSecondaryId($id,$data);
    }
    protected function executeDeleteMasterTableUsingSecondaryId($id){
        return $this->main_model->runDeleteMasteUsingSecondaryId($id);
    }
    protected function executeDeleteItemTableUsingSecondaryId($id){
        return $this->main_model->runDeleteItemsUsingSecondaryId($id);
    }
    protected function executeDeleteSubIteTableUsingSecondaryId($id){
        return $this->main_model->runDeleteSubItemsUsingSecondaryId($id);
    }
    protected function executeSelectMasterTableUsingSecondaryId($id){
        return $this->main_model->runSelectMasterUsingSecondaryId($id);
    }
    protected function executeSelectItemTableUsingSecondaryId($id){
        return $this->main_model->runSelectItemsUsingSecondaryId($id);
    }
    protected function executeSelectSubItemsTableUsingSecondaryId($id){
        return $this->main_model->runSelectSubItemsUsingSecondaryId($id);
    }
    //customizeble functions 
     protected function getPendingSTNListForBasicDataTable($param_data){
        $values    = $this->main_model->runGetPendingSTN($param_data['id'],$param_data['custom_condition']);
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=count($values);
        return $return_data;
    }
     protected function getSelectedSTNListForBasicDataTable($param_data){
        $values    = $this->main_model->runGetSelectedSTN($param_data['id'],$param_data['custom_condition']);
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=count($values);
        return $return_data;
    }
    
     protected function getNotCompleteStoreNoteForBasicDataTableOnServerSide($param_data){
        $values         = $this->main_model->runGetNotCompleteSTNListServerSide($param_data['start'], $param_data['length'], $param_data['search_key_val'],$param_data['custom_condition']);
        if ($param_data['search_key_val']) {
            $value_count  = $this->main_model->runGetNotCompleteSTNListServerSide('', '', $param_data['search_key_val'],$param_data['custom_condition']);
        }else{
            $value_count    = $this->main_model->runGetNotCompleteSTNListServerSide('', '', '',$param_data['custom_condition']);
        }
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=$value_count;
        return $return_data;
    }
     protected function getSelectedSTNMaterialListForBasicDataTable($param_data){
        $values    = $this->main_model->runGetSelectedSTNMaterial($param_data['id'],$param_data['custom_condition']);
        $return_data=array();
        $return_data['values']=$values;
        $return_data['value_count']=count($values);
        return $return_data;
    }
    
    
    

   
  
}