<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Area extends CI_Controller {

    var $main_menu_name = "settings";
	var $sub_menu_name = "area";
	
	public function __construct()
	{
		parent::__construct();

		$this->load->model('Area_Model');
		$this->load->model('Common_Model');
		$this->load->model('Warehouse_Model');
		$this->load->model('Sequerty_Model');
	}

	public function index()
	{
		$data['main_menu_name'] = $this->main_menu_name;
		$data['sub_menu_name'] = $this->sub_menu_name;
        $this->load->view('area',$data);
	}
	
	
	public function get_all_area_by_warehouse_id()
	{
	
		$warehouse_id=$this->input->get('WH');
		$area = $this->Area_Model->get_all_area_by_warehouse_id($warehouse_id);
		echo json_encode($area);
	
	}

	public function save_area()
	{   $area_id=$this->input->post('area_id');
		$type=$this->input->post('type');
		$area_code=$this->input->post('area_code');		
		$area_name=$this->input->post('area_name');
		$warehouse_id=$this->input->post('warehouse_id');
		$date_time = date('Y-m-d H:i:s');
		$added_by=$this->session->userdata('ss_user_id');
		
		
		$data=array(
			'area_code'=>$area_code,
			'area_name'=>$area_name,
			'warehouse_id'=>$warehouse_id,	
			'date_time'=>$date_time,
			'added_by'=>$added_by
				
		);
		
		$this->load->library('form_validation'); //form validation lib
		if($type=='A')
		{	
			$area_id='';
			$this->form_validation->set_rules('area_code', 'Area Code', 'required|is_unique[master_area.area_code]');
		}
		else if($type=='E')
		{
			$this->form_validation->set_rules('area_code', 'Code', 'required');
		}
		
		if ($this->form_validation->run() == FALSE)
        {
           $st = array('status' =>0,'validation' => validation_errors());
           echo json_encode($st);
        }
        else
        {
		
		$_insert=$this->Area_Model->save_area($data,$area_id);
		$lastid=$this->db->insert_id();

		if($type=='A'){
			if ($lastid) {
				echo json_encode(array('id'=>$lastid,'type'=>$type));
			} else {
				echo json_encode(array('status'=>'error'));
			}
		}
		if($type=='E'){
			echo json_encode(array('type'=>$type));
		}
		}
	}

	public function add_area()
	{
		//$area_id = $this->input->get('area_id');
		
        if (isset($_GET['area_id'])) {
			$area_id=$_GET['area_id'];
		}
		else {
			$area_id='';
		}
		if($area_id){//echo $area_id;
			$data['area_id']=$area_id;
			$data['type']='E';
			$data['pageName']='UPDATE  AREA';
			$data['btnText']='Update Area';
			$data['area_details']= $this->Area_Model->get_area_info($area_id);
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
			
		}
		else {
			$data['area_id']='';
			$data['type']='A';
			$data['pageName']='ADD Area';
			$data['btnText']='Add Area';
			$data['area_details']=array();
			$data['warehouse_list'] = $this->Warehouse_Model->get_all_warehouse();
		}
        $this->load->view('models/create_area',$data);
	}

	public function list_area()
	{
	$requestData= $_REQUEST;
	
	$data = array();
	$area = $this->Area_Model->get_all_area();
	$totalData = count($area );
	$totalFiltered = $totalData;  
	
	foreach ($area as $row){
		$nestedData=array(); 
		$nestedData[] =$row['area_id'];
		$nestedData[] =$row['area_code'];
		$nestedData[] = $row['area_name'];
		$nestedData[] = $row['date_time'];
		$nestedData[] = $row['user'];
		$actionTxtDisble='';
		$actionTxtEnable='';
		$actionTxtUpdate='';
		$actionTxtDelete='';
		$actionTxtUpdate='<a onClick="click_area_update_btn('.$row['area_id'].')" data-toggle="modal" href="#" class="btn btn-xs btn-blue tooltips" data-placement="top" data-original-title="Edit suppliers"><i class="glyphicon fa fa-edit"></i></a> &nbsp;';
		if($row['status']==1){
			$actionTxtDisble = '<a class="btn btn-xs btn-green tooltips" data-placement="top" data-original-title="Disable supplier" onClick="disableUnitData('.$row['area_id'].')"><i class="glyphicon fa fa-check"></i></a> &nbsp;';
	}
		if($row['status']==0){
			$actionTxtEnable = '<a class="btn btn-xs btn-warning tooltips" data-placement="top" data-original-title="Disable supplier" onClick="enableUnitData('.$row['area_id'].')"><i class="glyphicon fa fa-minus-circle"></i></a> &nbsp;';
	}
		$actionTxtDelete='<a class="btn btn-xs btn-bricky tooltips" data-placement="top" data-original-title="Delete supplier" onClick="deleteUnitData('.$row['area_id'].')">
															<i class="glyphicon fa fa-trash-o"></i></a>';
	
	$nestedData[]=$actionTxtUpdate.$actionTxtDisble.$actionTxtEnable.$actionTxtDelete;
	$data[] = $nestedData;
}

	$json_data = array(
			//"draw"            => intval( $requestData['draw'] ),  
			"recordsTotal"    => intval( $totalData ),  
			"recordsFiltered" => intval( $totalFiltered ),
			"data"            => $data 
			);

	echo json_encode($json_data); 
	}


	function delete_area() {
		$area_code	= $this->input->post('area_id');
		$this->Area_Model->delete_area($area_id);
        if ($area_code) {
        	echo json_encode(array('id'=>$area_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function disable_area() {
		$area_code	= $this->input->post('area_id');
		$this->Area_Model->disable_area($area_id);
        if ($area_code) {
        	echo json_encode(array('id'=>$area_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}
	
	function enable_area() {
		$area_code	= $this->input->post('area_id');
		$this->Area_Model->enable_area($area_id);
        if ($area_code) {
        	echo json_encode(array('id'=>$area_id));
        } else {
        	echo json_encode(array('status'=>'error'));
        }
	}	
	

}